% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_subst_model_xml.R
\name{create_subst_model_xml}
\alias{create_subst_model_xml}
\title{Internal function to create the \code{substModel} section}
\usage{
create_subst_model_xml(inference_model)
}
\arguments{
\item{inference_model}{a Bayesian phylogenetic inference model.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.
Use \link{create_inference_model} to create an inference model.
Use \link{check_inference_model} to check if  an inference model is valid.
Use \link{rename_inference_model_filenames} to rename the files in an
inference model.}
}
\value{
the \code{substModel} section as XML text
}
\description{
Internal function to create the \code{substModel} section
}
\examples{
check_empty_beautier_folder()

# Inference model must be initialized
inference_model <- create_inference_model(
  site_model = create_jc69_site_model(id = 123)
)
create_subst_model_xml(
  inference_model = inference_model
)

check_empty_beautier_folder()
}
\author{
Richèl J.C. Bilderbeek
}
