% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_beauti_options.R
\name{create_beauti_options}
\alias{create_beauti_options}
\title{Function to create a set of `BEAUti` options.}
\usage{
create_beauti_options(
  capitalize_first_char_id = FALSE,
  nucleotides_uppercase = FALSE,
  beast2_version = "2.4",
  required = "",
  sequence_indent = 20,
  status = "",
  namespace = get_default_beast_namespace_v2_4()
)
}
\arguments{
\item{capitalize_first_char_id}{must the ID of alignment start with a
capital? TRUE if yes, FALSE if it can be left lower case (if it is
lowercase)}

\item{nucleotides_uppercase}{must the nucleotides of the DNA sequence be
in uppercase?}

\item{beast2_version}{the BEAST2 version}

\item{required}{things that may be required,
for example \code{BEAST v2.5.0}}

\item{sequence_indent}{the number of spaces the XML \code{sequence}
lines are indented}

\item{status}{the BEAUti status}

\item{namespace}{the `namespace` XML element in the `beast` XML tag.}
}
\value{
a BEAUti options structure
}
\description{
`BEAUti` options are settings that differ between `BEAUti`
version. The use of these options is mostly for testing
older versions
Whatever option chosen here, the created XML file will be valid.
}
\details{
Available BEAUti options are:\cr
  * \link{create_beauti_options_v2_4}
  * \link{create_beauti_options_v2_6}

`beautier` uses v2.4 by default, as this is when the first tests
were written.
}
\examples{
if (is_on_ci()) {

  check_empty_beautier_folder()

  beauti_options <- create_beauti_options_v2_4()
  xml <- create_beast2_input(
    get_fasta_filename(),
    beauti_options = beauti_options
  )

  check_empty_beautier_folder()
}
}
\author{
Richèl J.C. Bilderbeek
}
