% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_beast2_options_filenames.R
\name{rename_beast2_options_filenames}
\alias{rename_beast2_options_filenames}
\title{Rename the filenames in the BEAST2 options}
\usage{
rename_beast2_options_filenames(beast2_options, rename_fun)
}
\arguments{
\item{beast2_options}{a set of BEAST2 options,
that are the R equivalent of the BEAST2 command-line options,
as can be created by \link{create_beast2_options}}

\item{rename_fun}{a function to rename a filename,
as can be checked by \link[beautier]{check_rename_fun}. This function should
have one argument, which will be a filename or \link{NA}. The
function should \link{return} one filename (when passed one filename) or
one \link{NA} (when passed one \link{NA}).
Example rename functions are:
\itemize{
  \item \link[beautier]{get_remove_dir_fun} get a function
    that removes the directory
    paths from the filenames, in effect turning these into local files
  \item \link[beautier]{get_replace_dir_fun} get a function
    that replaces the directory
    paths from the filenames
  \item \link[beautier]{get_remove_hex_fun} get a function that
    removes the hex string from filenames.
    For example, \code{tracelog_82c1a522040.log} becomes \code{tracelog.log}
}}
}
\value{
a `beast2_options` with the filenames it contains renamed
}
\description{
Rename the filenames in the BEAST2 options
}
\examples{
check_empty_beaustier_folders()

# beast2_options with local filenames
beast2_options <- create_beast2_options(
  input_filename = "my.fas",
  output_state_filename = "my_state.xml.state"
)
# Rename filenames to be in /my/new/folder
rename_beast2_options_filenames(
  beast2_options = beast2_options,
  rename_fun = beautier::get_replace_dir_fun("/my/new/folder")
)

check_empty_beaustier_folders()
}
\author{
Richèl J.C. Bilderbeek
}
