% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/17_protectiveCallInitialValueV0.R
\name{protectiveCallInitialValueV0}
\alias{protectiveCallInitialValueV0}
\title{Displays per share Net Credit (V0Cr) on initiation day for Protective Call and draws its graph in the Plots tab.}
\usage{
protectiveCallInitialValueV0(
  ST,
  X,
  C,
  S0,
  hl = 0.5,
  hu = 1.5,
  xlab = "Spot Price ($)",
  ylab = "Initial Value V0 ($)",
  main = "Protective Call / Married Call / SyntheticPut"
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X}{Strike Price or eXercise price.}

\item{C}{Call Premium.}

\item{S0}{Initial Stock Price.}

\item{hl}{lower bound value for setting lower-limit of x-axis displaying spot price.}

\item{hu}{upper bound value for setting upper-limit of x-axis displaying spot price.}

\item{xlab}{X-axis label.}

\item{ylab}{Y-axis label.}

\item{main}{Title of the Graph.}
}
\value{
Returns a graph of the strategy.
}
\description{
Displays per share Net Credit (V0Cr) on initiation day for Protective Call and draws its graph in the Plots tab.
}
\details{
According to conceptual details given by Cohen (2015), and a closed-form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Net Credit (V0Cr) on initiation day for Protective Call and draw its graph in the Plots tab. EXAMPLE, Short HypoMedia stock at $14.00 (inflow) and buy HypoMedia December 15 call at $2.00 (outflow). This is a net credit trade as the net cash inflow equals shorted price realized minus call premium (call price) paid on call purchase.
}
\examples{
protectiveCallInitialValueV0(15,15,2,14)
protectiveCallInitialValueV0(50,50,3,48,hl=0.8,hu=1.2)
protectiveCallInitialValueV0(1000,1000,20,998,hl=0.995,hu=1.01)
}
\references{
Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group. https://bookshelf.vitalsource.com/books/9780133964448\cr
Kakushadze, Z., & Serur, J. A. (2018, August 17). 151 Trading Strategies. Palgrave Macmillan. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3247865
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
