% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tournament_methods.R
\name{autoplot.tournament}
\alias{autoplot.tournament}
\title{Autoplot method for discharge rating curve tournament}
\usage{
\method{autoplot}{tournament}(object, ..., type = "deviance")
}
\arguments{
\item{object}{an object of class "tournament"}

\item{...}{other plotting parameters (not used in this function)}

\item{type}{a character denoting what type of plot should be drawn. Possible types are
\itemize{
 \item{"deviance"}{ to plot the deviance of the four models.}
}}
}
\value{
returns an object of class "ggplot2".
}
\description{
Compare the four discharge rating curves from the tournament object in different ways
}
\examples{
\donttest{
library(ggplot2)
data(krokfors)
set.seed(1)
t_obj <- tournament(formula=Q~W,data=krokfors,num_cores=2)
autoplot(t_obj)
}
}
\seealso{
\code{\link{tournament}} to run a discharge rating curve tournament and \code{\link{summary.tournament}} for summaries.
}
