% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcp.R
\name{bcpImport}
\alias{bcpImport}
\title{Import data to SQL Server}
\usage{
bcpImport(
  x,
  connectargs,
  table,
  fieldterminator = "\\t",
  rowterminator = ifelse(.Platform$OS.type == "windows", "\\r\\n", "\\n"),
  overwrite = FALSE,
  spatialtype = c("geometry", "geography"),
  bcpOptions = list("-b", 1000, "-a", 4096, "-m", 10),
  ...
)
}
\arguments{
\item{x}{dataframe object or path to file}

\item{connectargs}{named list of connection arguments. See \link[bcputility]{makeConnectArgs}.}

\item{table}{Name of the source table when importing from  SQL Server. For specifying the
schema in the table name see \code{<schema>.<table>} and if not specified the
default is "dbo".}

\item{fieldterminator}{character separator for columns}

\item{rowterminator}{character separator for rows--new lines}

\item{overwrite}{Whether to overwrite the table if it exists}

\item{spatialtype}{spatial data type for schema
\url{https://learn.microsoft.com/en-us/sql/relational-databases/spatial/spatial-data-types-overview},
ignored if \code{x} is not an 'sf' object}

\item{bcpOptions}{list of additional options to pass to the 'bcp' utility. See details.}

\item{...}{arguments to pass to \link[base]{system2}}
}
\value{
Output from \code{system2}. See \code{...} to redirect output.
}
\description{
A wrapper for a system call to the bcp utility which bulk inserts to SQL
Server.
}
\details{
If x is a dataframe object, \code{data.table::fwrite} is used to write the
in memory object to disk in a temporary file that is deleted when the
function exits. The \code{fieldterminator} and \code{rowterminator} are
ignored in this case.

If \code{overwrite} is \code{TRUE}, any existing table of the same name
will be deleted and the schema is inferred from \code{DBI::dbCreateTable}. To
use a customized schema, create the schema before calling the function and
use \code{overwrite=FALSE}.

If x is a sf object, the geometry column is converted to binary and
written to the database before conversion to geometry/geometry data type.
The EPSG code is automatically read from the sf object and used as the
SRID.

To override the default path to the bcp command line utility, set the
\code{bcputility.bcp.path} option.
To override the default path to the sqlcmd command line utility, set the
\code{bcputility.sqlcmd.path} option.

The \code{bcpOptions} allows the user to include additional arguments for the
call to \code{system2}. Please refer to
\url{https://learn.microsoft.com/en-us/sql/tools/bcp-utility}.
The default options are set to the defaults for \code{bcp} CLI. \code{-b}
refers to number of rows to write at a time; 10,000 to 50,000 is a
starting recommendation. \code{-a} refers to size of packets to be sent in
bytes. \code{-e} refers to the maximum number of errors before failure.

If a \code{bcpOptions} option has a text argument such as a file path, it
is recommended to use \code{shQuote} to ensure proper handling of spaces /
special characters for the system call.
}
