% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov.bclogit.R
\name{vcov.bclogit}
\alias{vcov.bclogit}
\title{Extract variance-covariance matrix from a bclogit model}
\usage{
\method{vcov}{bclogit}(object, ...)
}
\arguments{
\item{object}{A \code{bclogit} object.}

\item{...}{Additional arguments.}
}
\value{
A square matrix of the posterior covariance of the coefficients,
derived from the MCMC samples.
}
\description{
Extract variance-covariance matrix from a bclogit model
}
\examples{
\donttest{
data("fhs")
fit <- bclogit(PREVHYP ~ TOTCHOL + BMI, data = fhs,
               treatment = PERIOD, strata = RANDID)
vcov(fit)
}
}
\seealso{
\code{\link{coef.bclogit}}, \code{\link{summary.bclogit}}
}
