% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.bclogit.R
\name{summary.bclogit}
\alias{summary.bclogit}
\title{Summarize a bclogit model}
\usage{
\method{summary}{bclogit}(object, level = 0.95, inference_method = "HPD_one", ...)
}
\arguments{
\item{object}{A \code{bclogit} object.}

\item{level}{Confidence level for credible intervals (default 0.95).}

\item{inference_method}{Method used for both the displayed confidence set bounds and the
p-value (computed via bisection over alpha). Options are:
\code{"HPD_one"} (default) uses unimodal HPD intervals (C++) with 20 bisection iterations,
\code{"HPD_many"} uses \code{ggdist::hdi} which supports disjoint (multimodal) HPD regions,
with 50 bisection iterations (requires the \pkg{ggdist} package).
Confidence set bounds are shown when the HPD is a single interval; if disjoint,
they are set to \code{NA} (use \code{\link{confint.bclogit}} with \code{type = "HPD_many"}
to see all intervals),
\code{"CR"} uses equal-tailed credible intervals (quantile-based, C++) with 20 bisection iterations.}

\item{...}{Additional arguments (not used).}
}
\value{
A list of class \code{"summary.bclogit"} containing:
\item{call}{The original function call.}
\item{coefficients}{A matrix with one row per parameter and columns for the posterior mean
estimate, posterior median estimate, standard error, lower and upper credible interval bounds,
optionally \code{Rhat} and \code{n_eff} convergence diagnostics (when available from Stan),
and \code{Pr(tx!=0)} (the Bayesian p-value).}
\item{num_discordant}{Number of discordant pairs used for fitting.}
\item{num_concordant}{Number of concordant pairs used for the prior.}
\item{level}{The credible interval level used.}
\item{inference_method}{The inference method used for interval and p-value computation.}
\item{prior_info}{A list with elements \code{mu} and \code{Sigma} describing the prior
derived from the concordant pairs model.}
\item{treatment_name}{Name of the treatment variable.}
}
\description{
Summarize a bclogit model
}
\seealso{
\code{\link{print.summary.bclogit}}, \code{\link{confint.bclogit}},
\code{\link{coef.bclogit}}, \code{\link{vcov.bclogit}}
}
