% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula.bclogit.R
\name{formula.bclogit}
\alias{formula.bclogit}
\title{Extract model formula}
\usage{
\method{formula}{bclogit}(x, ...)
}
\arguments{
\item{x}{A \code{bclogit} object.}

\item{...}{Additional arguments.}
}
\value{
The \code{formula} used in the model, or \code{NULL} when the model was
fitted via the default (matrix) interface.
}
\description{
Extract model formula
}
\examples{
\donttest{
data("fhs")
fit <- bclogit(PREVHYP ~ TOTCHOL + BMI, data = fhs,
               treatment = PERIOD, strata = RANDID)
formula(fit)
}
}
\seealso{
\code{\link{bclogit}}
}
