% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clogit.default.R, R/clogit.formula.R,
%   R/clogit_S3.R
\name{clogit.default}
\alias{clogit.default}
\alias{clogit.formula}
\alias{clogit}
\title{Frequentist Conditional Logistic Regression}
\usage{
\method{clogit}{default}(
  formula = NULL,
  data = NULL,
  treatment = NULL,
  strata = NULL,
  subset = NULL,
  na.action = NULL,
  do_inference_on_var = "all",
  ...,
  y = NULL,
  X = NULL,
  treatment_name = NULL,
  call = NULL
)

\method{clogit}{formula}(
  formula,
  data,
  treatment = NULL,
  strata = NULL,
  subset = NULL,
  na.action = NULL,
  do_inference_on_var = "all",
  ...
)

clogit(
  formula,
  data,
  treatment = NULL,
  strata = NULL,
  subset = NULL,
  na.action = NULL,
  do_inference_on_var = "all",
  ...
)
}
\arguments{
\item{formula}{For the formula method, a symbolic description of the model.}

\item{data}{A data frame containing the variables (for formula method).}

\item{treatment}{Vector specifying the treatment variable.}

\item{strata}{Vector specifying the strata (matched pairs).}

\item{subset}{An optional vector specifying a subset of observations to be used in the fitting process.}

\item{na.action}{A function which indicates what should happen when the data contain NAs.}

\item{do_inference_on_var}{Which variable(s) to compute standard errors for.
\code{"all"} (default) computes SEs for all coefficients. An integer \code{j}
computes the SE only for the \code{j}th coefficient (1 = treatment, then covariates
in order). \code{"none"} skips inference entirely.}

\item{...}{Additional arguments passed to
\code{fastLogisticRegressionWrap::fast_logistic_regression} (e.g., convergence
tolerances).}

\item{y}{For the default method, a binary (0,1) response vector.}

\item{X}{A data.frame, data.table, or model.matrix containing the variables.}

\item{treatment_name}{Optional string name for the treatment variable.}

\item{call}{Optional call object to store in the result.}
}
\value{
A list of class \code{"clogit_bclogit"} containing:
\item{coefficients}{Estimated coefficients (posterior means).}
\item{var}{Variance-covariance matrix of the coefficients (diagonal, built from standard errors).
\code{NULL} when \code{do_inference_on_var} is not \code{"all"}.}
\item{flr_model}{The fitted fast logistic regression model object returned by
\code{fastLogisticRegressionWrap::fast_logistic_regression}.}
\item{call}{The function call.}
\item{terms}{The model terms.}
\item{n}{Total number of observations.}
\item{num_discordant}{Number of discordant pairs used for fitting.}
\item{num_concordant}{Number of concordant pairs.}
\item{X_model_matrix_col_names}{Column names of the covariate model matrix.}
\item{treatment_name}{Name of the treatment variable.}
\item{se}{Standard errors of the coefficients.}
\item{z}{Z-statistics for each coefficient.}
\item{pval}{Approximate p-values for each coefficient.}
\item{do_inference_on_var}{The value of the \code{do_inference_on_var} argument.}

An object of class \code{"clogit_bclogit"}.

An object of class \code{"clogit_bclogit"}.
}
\description{
Fits a conditional logistic regression model for matched pairs using
the discordant-pair GLM trick. This is a fast frequentist alternative
to \code{\link{bclogit}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{clogit(default)}: Default method for matrix/data input.

\item \code{clogit(formula)}: Formula method

}}
\examples{
data("fhs")
fit <- clogit(PREVHYP ~ TOTCHOL + CIGPDAY + BMI + HEARTRTE, 
  data = fhs, treatment = PERIOD, strata = RANDID)
summary(fit)
n <- 200
dat <- data.frame(
  y = rbinom(n, 1, 0.5),
  x1 = rnorm(n),
  treatment = rep(c(0, 1), n / 2),
  strata = rep(1:(n / 2), each = 2)
)
fit <- clogit(y ~ x1, data = dat, treatment = treatment, strata = strata)
# Inference on treatment only (faster):
fit2 <- clogit(y ~ x1, data = dat, treatment = treatment, strata = strata,
               do_inference_on_var = 1)
n <- 200
dat <- data.frame(
  y = rbinom(n, 1, 0.5),
  x1 = rnorm(n),
  x2 = rnorm(n),
  treatment = rep(c(0, 1), n / 2),
  strata = rep(1:(n / 2), each = 2)
)
fit <- clogit(y ~ x1 + x2, data = dat, treatment = treatment, strata = strata)
summary(fit)
coef(fit)
vcov(fit)
}
\seealso{
\code{\link{bclogit}}, \code{\link{summary.clogit_bclogit}},
\code{\link{coef.clogit_bclogit}}, \code{\link{vcov.clogit_bclogit}}
}
