% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simstdybcf.R
\name{simstdybcf}
\alias{simstdybcf}
\title{Simulation study for bivariate correlated frailty models.}
\usage{
simstdybcf(
  Rep,
  mfit = NULL,
  psize,
  cenr = c(0),
  beta = c(0.5),
  frailty,
  frailpar = c(0.5, 0.25),
  bhaz = c("weibull"),
  bhazpar = list(shape = c(0.5), scale = c(0.01)),
  covartype = c("B"),
  covarpar = list(fargs = c(1), sargs = c(0.5)),
  inpcovar = NULL,
  inpcen = NULL,
  comncovar = NULL
)
}
\arguments{
\item{Rep}{number of replications.}

\item{mfit}{A type of frailty model to be fit in addition to \code{bcfrailph}. mfit can be c("cox","shrg") where \code{cox} is for univariate or bivariate shared lognormal and gamma model fit using \code{coxph} and \code{shrg} is for univariate or bivariate shared gamma model fit using \code{\link{shrgamsp}}.}

\item{psize}{pair size.}

\item{cenr}{censored rate. The default is zero..}

\item{beta}{Covariate coefficient.}

\item{frailty}{A type of frailty distribution to be used. Either gamma or lognormal.}

\item{frailpar}{vector of frailty parameters, variance and correlation respectively. The default is c(0.5,0.25) meaning variance 0.5 and correlation 0.25.}

\item{bhaz}{A type of baseline hazard distribution to be used. it can be weibull, gompertz or exponential.}

\item{bhazpar}{is a \code{\link{list}} containing \code{scale} and\code{shape} of the specified baseline hazard distribution.}

\item{covartype}{specified the distribution from which covariate(s) are goining to be sampled. covartype can be c("B","N","U")denoting binomial, normal or uniform, respectively. For example, \code{covartype=c("B","B")} to generate two covariates both from a binomial distribution.}

\item{covarpar}{is a \code{\link{list}} containing parmeters of the specified covariate distribution with first and second arguments denoted by \code{fargs} and \code{sargs}, respectively. For example, if \code{covartype=c("B","U")} and \code{covarpar=list(fargs=c(1,0.3),sargs=c(0.5,1.3))}, generates two independent covariates from a binomial distribution (with parameters size=1 and probs=0.5) and from uniform distributions (with parameters min=0.3 and max=1.3).}

\item{inpcovar}{is a \code{\link{list}} i.e,list(covar1=x1,covar2=x2) to input covariates with both x1 and x2 is in matrix form.}

\item{inpcen}{is a \code{\link{list}} containing \code{cent1} and \code{cent2} denoting censoring time for the first and the second subjects in pairs respectively.}

\item{comncovar}{if common covariates are needed.}
}
\value{
An object of class \code{simstdybcf} that contain the following:
\itemize{

\item{\code{Result}} a summary result containing true parameter, mean of estimates, mean of the standard errors of the estimates, standard deviation of estimates, and 95\% CI coverage probability.

\item{\code{estimates}} a matrix containing estimates of parameters at each replications.

\item{\code{estimateSE}} a matrix containing standard error of estimates at each replications.

\item{\code{coverage}} a matrix containing an indicator whether the true parameter lies within a 95\% CI at each replications or not.

\item{\code{TMAT}} a matrix containing the generated artificial unique event times at each replications for gamma model.

\item{\code{h0MAT}} a matrix containing the estimated baseline hazards at each replications for gamma model.

\item{\code{h0SEMAT}} a matrix containing SE of the estimated baseline hazards at each replications for gamma model.}
}
\description{
Simulation study for bivariate correlated gamma and lognormal frailty models with and without covariates.
}
\examples{
set.seed(2)
sim<-simstdybcf(Rep=5,psize=100, cenr= c(0.2),beta=c(1,-0.7,0.5),
frailty=c("lognormal"),frailpar=c(0.5,-0.25),bhaz=c("exponential"),
bhazpar=list(scale = c(0.1)),covartype= c("N","N","B"),
covarpar=list(fargs=c(0,0,1),sargs=c(1,1,0.5)),comncovar=2)
Res<-sim$Result
Res

\donttest{
# In addition to bcfrailph fit, if coxph with univariate lognormal frailty model is desired to run,

sim<-simstdybcf(Rep=5,mfit="cox",psize=100, cenr= c(0.2),beta=c(1,-0.7,0.5),
frailty=c("lognormal"),frailpar=c(0.5,-0.25),bhaz=c("exponential"),
bhazpar=list(scale = c(0.1)),covartype= c("N","N","B"),
covarpar=list(fargs=c(0,0,1),sargs=c(1,1,0.5)),comncovar=2)
Res<-sim$Result # bcfrailph fit result
Res
Resc<-sim$Resultc # coxph with univariate lognormal frailty model fit result
Resc
}

}
\seealso{
\code{\link{simbcfrail}}
}
