% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BinaryPowerBSSR.R
\name{BinaryPowerBSSR}
\alias{BinaryPowerBSSR}
\title{Power Calculation for Two-Arm Trials with Binary Endpoints Using Blinded Sample Size Re-estimation (BSSR)}
\usage{
BinaryPowerBSSR(
  asmd.p1,
  asmd.p2,
  p,
  Delta.A,
  Delta.T,
  N1,
  N2,
  omega,
  r,
  alpha,
  tar.power,
  Test,
  restricted,
  weighted
)
}
\arguments{
\item{asmd.p1}{Assumed proportion of responders for group 1}

\item{asmd.p2}{Assumed proportion of responders for group 2}

\item{p}{Vector of pooled proportions of responders from both groups (can specify multiple values)}

\item{Delta.A}{Assumed treatment effect (risk difference)}

\item{Delta.T}{True treatment effect (risk difference)}

\item{N1}{Initial sample size of group 1}

\item{N2}{Initial sample size of group 2}

\item{omega}{Fraction of sample size used for interim analysis (i.e., for BSSR)}

\item{r}{Allocation ratio to group 1}

\item{alpha}{One-sided level of significance}

\item{tar.power}{Target power}

\item{Test}{Type of statistical test. Options: 'Chisq', 'Fisher', 'Fisher-midP', 'Z-pool', or 'Boschloo'}

\item{restricted}{Logical. If TRUE, restricted design is chosen}

\item{weighted}{Logical. If TRUE, weighted approach is chosen}
}
\value{
A data frame containing:
\describe{
\item{p1}{True probability of responders for group 1}
\item{p2}{True probability of responders for group 2}
\item{p}{True probability of pooled responders from both groups}
\item{power.BSSR}{Power for BSSR design}
\item{power.TRAD}{Power for traditional design}
}
}
\description{
Calculates the power for two-arm trials with binary endpoints when blinded sample size
re-estimation (BSSR) is implemented. The function supports five different statistical tests
and allows for both restricted and unrestricted designs with optional weighted approaches.
}
\details{
The function supports the following five one-sided tests:
\itemize{
\item The one-sided Pearson chi-squared test (Chisq)
\item The Fisher exact test (Fisher)
\item The Fisher mid-p test (Fisher-midP)
\item The Z-pooled exact unconditional test (Z-pool)
\item The Boschloo exact unconditional test (Boschloo)
}
}
\examples{
# Simple BSSR calculation with fast Chi-squared test
result1 <- BinaryPowerBSSR(
  asmd.p1 = 0.6, asmd.p2 = 0.3,
  p = 0.45,
  Delta.A = 0.3, Delta.T = 0.3,
  N1 = 5, N2 = 5, omega = 0.5, r = 1,
  alpha = 0.025, tar.power = 0.8,
  Test = 'Chisq',
  restricted = FALSE, weighted = FALSE
)
print(result1)

\donttest{
# More computationally intensive BSSR examples
result2 <- BinaryPowerBSSR(
  asmd.p1 = 0.45,
  asmd.p2 = 0.09,
  p = seq(0.14, 0.23, by = 0.01),
  Delta.A = 0.36,
  Delta.T = 0.36,
  N1 = 24,
  N2 = 24,
  omega = 0.5,
  r = 1,
  alpha = 0.025,
  tar.power = 0.8,
  Test = 'Z-pool',
  restricted = FALSE,
  weighted = TRUE
)
print(result2)
}

}
\author{
Gosuke Homma (\email{my.name.is.gosuke@gmail.com})
}
