% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_invgamma_parms.R
\name{find_invgamma_parms}
\alias{find_invgamma_parms}
\title{Find parameters for Inverse gamma prior based on prior mean and one quantile}
\usage{
find_invgamma_parms(
  lower_quantile,
  upper_quantile,
  response_variance,
  lower_R2,
  upper_R2,
  probability,
  plot_results = TRUE
)
}
\arguments{
\item{lower_quantile}{lower quantile desired}

\item{upper_quantile}{upper quantile desired}

\item{response_variance}{variance of the response variable of the regression model}

\item{lower_R2, upper_R2}{We are a priori \code{probability} sure that the
coefficient of determination (\eqn{R^2}) falls within these lower and upper bounds.}

\item{probability}{prior probability to be contained within the lower and upper quantiles}

\item{plot_results}{logical.  Should the resulting inverse gamma distribution be plotted?}
}
\value{
twice the shape and rate of the inverse gamma distribution.
}
\description{
Find parameters for Inverse gamma prior based on prior mean and one quantile
}
\details{
Either provide the lower and upper quantiles that contain \code{probability}
of the inverse gamma distribution, or if this is for linear regression, you
can specify that you are a priori \code{probability} sure that the coefficient
of determination (\eqn{R^2}) falls within the two bounds provided, assuming
that the residual variance is \eqn{1-R^2} times the total variance.
}
\examples{
# When aimed at linear regression via coefficient of determination...
hypothetical_s2_y = 2.0
lower_R2 = 0.05
upper_R2 = 0.85
find_invgamma_parms(response_variance = hypothetical_s2_y,
                    lower_R2 = lower_R2,
                    upper_R2 = upper_R2,
                    probability = 0.8)

# More arbitrary task...
find_invgamma_parms(0.3, # hypothetical_s2_y * (1.0 - upper_R2)
                    1.9, #hypothetical_s2_y * (1.0 - lower_R2)
                    probability = 0.8)




}
