% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesRecon-package.R
\docType{package}
\name{bayesRecon-package}
\alias{bayesRecon}
\alias{bayesRecon-package}
\title{bayesRecon: Probabilistic Reconciliation via Conditioning}
\description{
Provides methods for probabilistic reconciliation of hierarchical forecasts of time series. The available methods include analytical Gaussian reconciliation (Corani et al., 2021) \doi{10.1007/978-3-030-67664-3_13}, MCMC reconciliation of count time series (Corani et al., 2024) \doi{10.1016/j.ijforecast.2023.04.003}, Bottom-Up Importance Sampling (Zambon et al., 2024) \doi{10.1007/s11222-023-10343-y}, methods for the reconciliation of mixed hierarchies (Mix-Cond and TD-cond) (Zambon et al., 2024) \url{https://proceedings.mlr.press/v244/zambon24a.html}.
}
\section{Learn more}{


To learn more about \code{bayesRecon}, start with the vignettes: \code{browseVignettes(package = "bayesRecon")}
}

\section{Main functions}{


The package implements reconciliation via conditioning for probabilistic forecasts
of hierarchical time series. The main functions are:
\itemize{
\item \code{\link[=reconc_gaussian]{reconc_gaussian()}}: reconciliation via conditioning of multivariate Gaussian
base forecasts; this is done analytically;
\item \code{\link[=reconc_BUIS]{reconc_BUIS()}}: reconciliation via conditioning of any probabilistic forecast
via importance sampling; this is the recommended option for non-Gaussian base forecasts;
\item \code{\link[=reconc_MCMC]{reconc_MCMC()}}: reconciliation via conditioning of discrete probabilistic
forecasts via Markov Chain Monte Carlo;
\item \code{\link[=reconc_MixCond]{reconc_MixCond()}}: reconciliation via conditioning of mixed hierarchies, where
the upper forecasts are multivariate Gaussian and the bottom forecasts are discrete distributions;
\item \code{\link[=reconc_TDcond]{reconc_TDcond()}}: reconciliation via top-down conditioning of mixed hierarchies, where
the upper forecasts are multivariate Gaussian and the bottom forecasts are discrete distributions.
}
}

\section{Utility functions}{

\itemize{
\item \code{\link[=temporal_aggregation]{temporal_aggregation()}}: temporal aggregation of a given time series object of class \link[stats]{ts};
\item \code{\link[=get_reconc_matrices]{get_reconc_matrices()}}: aggregation and summing matrices for a temporal hierarchy
of time series from user-selected list of aggregation levels;
\item \code{\link[=schaferStrimmer_cov]{schaferStrimmer_cov()}}: computes the Schäfer-Strimmer shrinkage estimator for the covariance matrix;
\item \code{\link[=PMF.get_mean]{PMF.get_mean()}}, \code{\link[=PMF.get_var]{PMF.get_var()}}, \code{\link[=PMF.get_quantile]{PMF.get_quantile()}}, \code{\link[=PMF.summary]{PMF.summary()}}, \code{\link[=PMF.sample]{PMF.sample()}}:
functions for handling PMF objects.
}
}

\references{
Corani, G., Azzimonti, D., Augusto, J.P.S.C., Zaffalon, M. (2021).
\emph{Probabilistic Reconciliation of Hierarchical Forecast via Bayes' Rule}.
ECML PKDD 2020. Lecture Notes in Computer Science, vol 12459.
\doi{10.1007/978-3-030-67664-3_13}.

Corani, G., Azzimonti, D., Rubattu, N. (2024).
\emph{Probabilistic reconciliation of count time series}.
International Journal of Forecasting 40 (2), 457-469.
\doi{10.1016/j.ijforecast.2023.04.003}.

Zambon, L., Azzimonti, D. & Corani, G. (2024).
\emph{Efficient probabilistic reconciliation of forecasts for real-valued and count time series}.
Statistics and Computing 34 (1), 21.
\doi{10.1007/s11222-023-10343-y}.

Zambon, L., Agosto, A., Giudici, P., Corani, G. (2024).
\emph{Properties of the reconciled distributions for Gaussian and count forecasts}.
International Journal of Forecasting (in press).
\doi{10.1016/j.ijforecast.2023.12.004}.

Zambon, L., Azzimonti, D., Rubattu, N., Corani, G. (2024).
\emph{Probabilistic reconciliation of mixed-type hierarchical time series}.
Proceedings of the Fortieth Conference on Uncertainty in Artificial Intelligence,
PMLR 244:4078-4095. \url{https://proceedings.mlr.press/v244/zambon24a.html}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/IDSIA/bayesRecon}
  \item \url{https://idsia.github.io/bayesRecon/}
  \item Report bugs at \url{https://github.com/IDSIA/bayesRecon/issues}
}

}
\author{
\strong{Maintainer}: Dario Azzimonti \email{dario.azzimonti@gmail.com} (\href{https://orcid.org/0000-0001-5080-3061}{ORCID})

Authors:
\itemize{
  \item Nicolò Rubattu \email{nicolo.rubattu@idsia.ch} (\href{https://orcid.org/0000-0002-2703-1005}{ORCID})
  \item Lorenzo Zambon \email{lorenzo.zambon@idsia.ch} (\href{https://orcid.org/0000-0002-8939-993X}{ORCID})
  \item Giorgio Corani \email{giorgio.corani@idsia.ch} (\href{https://orcid.org/0000-0002-1541-8384}{ORCID})
}

}
\keyword{internal}
