% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_app.R
\name{run_app}
\alias{run_app}
\title{Shiny Application to Visualize Bayesian Regions of Evidence}
\usage{
run_app(
  onStart = NULL,
  options = list(launch.browser = TRUE),
  enableBookmarking = NULL,
  uiPattern = "/",
  init = NULL,
  cols = NULL,
  ...
)
}
\arguments{
\item{onStart}{A function that will be called before the app is actually run.
This is only needed for \code{shinyAppObj}, since in the \code{shinyAppDir}
case, a \code{global.R} file can be used for this purpose.}

\item{options}{Named options that should be passed to the \code{runApp} call
(these can be any of the following: "port", "launch.browser", "host", "quiet",
"display.mode" and "test.mode"). You can also specify \code{width} and
\code{height} parameters which provide a hint to the embedding environment
about the ideal height/width for the app.}

\item{enableBookmarking}{Can be one of \code{"url"}, \code{"server"}, or
\code{"disable"}. The default value, \code{NULL}, will respect the setting from
any previous calls to  \code{\link[shiny:enableBookmarking]{enableBookmarking()}}. See \code{\link[shiny:enableBookmarking]{enableBookmarking()}}
for more information on bookmarking your app.}

\item{uiPattern}{A regular expression that will be applied to each \code{GET}
request to determine whether the \code{ui} should be used to handle the
request. Note that the entire request path must match the regular
expression in order for the match to be considered successful.}

\item{init}{Named list containing the arguments that are passed to the bayesROE 
function: ee, se, delta, alpha.}

\item{cols}{Named list of RGB hexadecimal color keys.}

\item{...}{arguments to pass to golem_opts.
See `?golem::get_golem_options` for more details.}
}
\description{
Initialize and execute a local Shiny session to 
    interactively visualize and explore the Bayesian Regions of Evidence.
    Parameters entries from the sidebar are passed to the bayesROE function.
}
\examples{
# reproducing Figure 3 from Hoefler and Miller (2023)
init <- list(ee = 9, se = 3.9, delta = c(0, 3.75), alpha = 0.025)
cols <- list(col_lower = "#F5FF82", col_upper = "#27CC1E")
if(interactive()){
   run_app(init = init, cols = cols)
}

}
