% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_rasterROE.R
\name{rasterROE}
\alias{rasterROE}
\title{Bayesian Regions of Evidence Raster Plot}
\usage{
rasterROE(
  ee,
  se,
  delta = 0,
  alpha = 0.025,
  type = "threshold",
  larger = TRUE,
  meanLim = c(-3 * abs(ee), 3 * abs(ee)),
  sdLim = c(0, 5 * se),
  nGrid = 200,
  cols = NULL,
  cols_alpha = 1,
  add = FALSE
)
}
\arguments{
\item{ee}{Effect estimate.}

\item{se}{Standard error of effect estimate.}

\item{delta}{Minimally relevant effect size. Defaults to zero. Can also be a
vector of numerical values to representing different regions.}

\item{alpha}{Posterior probability that the effect size is less extreme than
delta. Defaults to 0.025. Can also be a vector of numerical values 
representing different regions.}

\item{type}{Character indicating if regions of evidence should be constructed 
for a non-inferiority claim using the first element of delta and all 
elements of alpha ("threshold"), for a non-inferiority claim using the 
all elements of delta and the first element of alpha ("probability"), 
for an equivalence claim using the first two elements of delta 
and all elements of alpha ("equivalence"), or for a prior-data 
conflict using only the first element of alpha ("conflict").
Defaults to "threshold".}

\item{larger}{Logical indicating if effect size should be larger (TRUE) or
smaller (FALSE) than delta. Ignored when type = "equivalence" or 
type = "conflict". Defaults to TRUE.}

\item{meanLim}{Limits of prior mean axis.}

\item{sdLim}{Limits of prior standard deviation axis.}

\item{nGrid}{Resolution of grid points (on both axes). Defaults to 200.}

\item{cols}{Character containing the HEX color code of the upper and lower
region of evidence, respectively. Defaults to NULL, which triggers
automated color picking by calling ggplot2:scale_fill_viridis_d()}

\item{cols_alpha}{Numeric value indicating the relative opacity of any
region of evidence (alpha channel). Defaults to 1 (no transparency).}

\item{add}{Logical indicating if a separate geom_raster layer should be 
created that can be added to an existing plot (TRUE), or if an entire 
regions of plot should be created (FALSE).
Defaults to FALSE.}
}
\value{
A bayesROE object (a list containing the ggplot object, the data for
    the plot, and the empty tipping point function)
}
\description{
Compute and visualize the Bayesian Regions of Evidence (Raster),
    that is, the set of normal priors for an effect size which - 
    when combined with the observed data - lead to a specified posterior
    probability for the effect size being more extreme than a specified
    minimally relevant effect size.
}
\examples{
## data with p < 0.025 for H0: delta < 0, but p > 0.025 for H0: delta < 0.3
d <- 0.4
d_se <- 0.1
delta <- c(0, 0.3)
\donttest{
rasterROE(ee = d, se = d_se, delta = delta, meanLim = c(-1, 1))
}

## reproducing Figure 3 from Hoefler & Miller (2023)
ee <- 9
se <- 3.9
delta <- c(0, 3.75)
\donttest{
rasterROE(ee = ee, se = se, delta = delta, alpha = 0.05)$plot +
  ggplot2::annotate(geom = "point", y = ee, x = se, shape = 4)
  ggplot2::coord_flip(xlim = c(0, 12), ylim = c(-5, 10))
}

}
\references{
Hoefler, M., Miller, R. (2022, April 04). Bayesian regions of evidence (for normal
 distributions). \doi{10.31234/osf.io/mg23h}
}
