% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior-class.R
\name{prior}
\alias{prior}
\title{Build a joint prior for bayesPO model parameters}
\usage{
prior(beta, delta, lambdaStar)
}
\arguments{
\item{beta}{An S4 object whose class inherits from \code{BetaDeltaPrior}.}

\item{delta}{An S4 object whose class inherits from \code{BetaDeltaPrior}.}

\item{lambdaStar}{An S4 object whose class inherits from \code{LambdaStarPrior}.}
}
\value{
A \code{bayesPO_prior} object with the adequate slots. It is ready to
be included in a model via the \code{bayesPO_model} function.
}
\description{
Constructor for \code{bayesPO_prior} objects, which is used in the
\code{bayesPO_fit} function. The generated prior is so that Beta, Delta
and LambdaStar are indepdendent a priori.
}
\examples{
# Let us say there are 3 intensity covariates and 4 observability covariates.
# One more element is included in both sets due to the intercepts.
new_prior <- prior(
  NormalPrior(rep(0, 4), 10 * diag(4)),
  NormalPrior(rep(0, 5), 10 * diag(5)),
  GammaPrior(0.0001, 0.0001)
)
}
\seealso{
\code{\link{fit_bayesPO}}, \code{\link{NormalPrior}},
\code{\link{GammaPrior}} and \code{\link{bayesPO_model}}.
}
