% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_outputs.R
\name{summary.bayesMig.prediction}
\alias{summary.bayesMig.prediction}
\alias{print.summary.bayesMig.prediction}
\title{Summary of Prediction of Net Migration Rate}
\usage{
\method{summary}{bayesMig.prediction}(object, country = NULL, compact = TRUE, ...)

\method{print}{summary.bayesMig.prediction}(x, digits = 3, ...)
}
\arguments{
\item{object}{Object of class \code{\link{bayesMig.prediction}}.}

\item{country}{Location name or code if a location-specific summary is desired. 
The code can be either numeric or (if locations are countries) ISO-2 or ISO-3 characters. 
If it is \code{NULL}, only prediction meta info is included.}

\item{compact}{Logical switching between a smaller and larger number of displayed quantiles.}

\item{\dots}{A list of further arguments.}

\item{x}{A result of the \code{summary} function.}

\item{digits}{Minimal number of significant digits.}
}
\value{
\code{summary} returns a list with objects \code{burnin}, \code{nr.traj}, \code{projection.years},
    \code{country.name} containing the MCMC burn-in, number of trajectories, projected years
    and name of the location, respectively. The projection results are stored in the item 
    \code{projections} which is a matrix with rows being the years and columns being the mean
    and various quantiles.
}
\description{
Summary of an object of class \code{\link{bayesMig.prediction}}, 
    created using the function \code{\link{mig.predict}}. The summary contains the mean, 
    standard deviation and several commonly used quantiles of the simulated trajectories.
}
\examples{
# See example in ?mig.predict
}
