% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{mig.pardensity.plot}
\alias{mig.pardensity.plot}
\alias{mig.pardensity.cs.plot}
\title{Plotting MCMC Parameter Density}
\usage{
mig.pardensity.plot(
  mcmc.list = NULL,
  sim.dir = NULL,
  chain.ids = NULL,
  par.names = mig.parameter.names(),
  burnin = NULL,
  dev.ncol = 2,
  low.memory = TRUE,
  ...
)

mig.pardensity.cs.plot(
  country,
  mcmc.list = NULL,
  sim.dir = NULL,
  chain.ids = NULL,
  par.names = mig.parameter.names.cs(),
  burnin = NULL,
  dev.ncol = 3,
  low.memory = TRUE,
  ...
)
}
\arguments{
\item{mcmc.list}{List of \code{\link{bayesMig.mcmc}} objects, or an object of class
\code{\link{bayesMig.mcmc.set}} or of class \code{bayesMig.prediction}. If it is \code{NULL}, the 
values are loaded from \code{sim.dir}.}

\item{sim.dir}{Directory with the MCMC simulation results. It is only used if \code{mcmc.list} is \code{NULL}.}

\item{chain.ids}{List of MCMC identifiers to be plotted. If it is \code{NULL}, all chains found in 
\code{mcmc.list} or \code{sim.dir} are plotted.}

\item{par.names}{Names of parameters for which density should be plotted. By default all 
country-independent parameters are plotted if used within \code{mig.pardensity.plot}, or 
country-specific parameters are plotted if used within \code{mig.pardensity.cs.plot}.}

\item{burnin}{Number of iterations to be discarded from the beginning of each chain before 
computing the density.}

\item{dev.ncol}{Number of column for the graphics device. If the number of parameters is smaller
than \code{dev.ncol}, the number of columns is automatically decreased.}

\item{low.memory}{Logical indicating if the processing should run in a low-memory mode. If it is 
\code{FALSE}, traces of all available parameters are loaded into memory. Otherwise, parameters are
loaded as they are needed.}

\item{\dots}{Further arguments passed to the \code{\link{density}} function.}

\item{country}{Name or numerical code of a country. It can also be given as ISO-2 or ISO-3 characters.}
}
\value{
No return value.
}
\description{
Functions for plotting the density of the posterior distribution of the MCMC parameters from the migration model.
}
\details{
The functions plot the density of the posterior distribution either for 
    country-independent parameters (\code{mig.pardensity.plot} or for country-specific 
    parameters (\code{mig.pardensity.cs.plot}, one graph per parameter.  
    One can restrict it to specific chains by setting the \code{chain.ids} argument and to specific 
    parameters by setting the \code{par.names} argument. 
    
    If \code{mcmc.list} is an object of class \code{\link{bayesMig.prediction}} 
    and if this object contains thinned traces, they are used instead of the full chains. 
    In such a case, \code{burnin} and \code{chain.ids} cannot be modified - their value is set 
    to the one used when the thinned traces were created, namely when running 
    \code{\link{mig.predict}}. In a situation with long MCMC chains, this approach can  
    significantly speed-up creation of the density plots.
}
