% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_outputs.R
\name{mig.coda.list.mcmc}
\alias{mig.coda.list.mcmc}
\title{Conversion to coda-formatted objects}
\usage{
mig.coda.list.mcmc(
  mcmc.list = NULL,
  country = NULL,
  chain.ids = NULL,
  sim.dir = NULL,
  par.names = NULL,
  par.names.cs = NULL,
  low.memory = FALSE,
  ...
)
}
\arguments{
\item{mcmc.list}{A list of objects of class \code{bayesMig.mcmc}, or an object of class \code{\link{bayesMig.mcmc.set}} or \code{\link{bayesMig.prediction}}.
If \code{NULL}, the MCMCs are
loaded from \code{sim.dir}. Either \code{mcmc} or \code{sim.dir} must be given.}

\item{country}{Location name or code. Used in connection with the \code{par.names.cs} argument
(see below).}

\item{chain.ids}{Vector of chain identifiers. By default, all chains available in the \code{mcmc.list}
object are included.}

\item{sim.dir}{Directory with the MCMC simulation results. Only used if \code{mcmc.list} is \code{NULL}.}

\item{par.names}{Names of country-independent parameters to be included. Default names are
those returned by the \code{mig.parameter.names} function, which includes all country-independent
parameters in the BHM.}

\item{par.names.cs}{Names of country-specific parameters to be included. The argument \code{country}
is used to filter out traces that correspond to a specific location. If \code{country} is not given, 
traces of each parameter are given for all countries. Default names are those returned by 
\code{mig.parameter.names.cs()}, which includes all country-specific parameters in the BHM.}

\item{low.memory}{Logical indicating if the function should run in a memory-efficient mode.}

\item{\dots}{Additional arguments passed to the \pkg{coda}'s \code{\link[coda]{mcmc}} function, such as \code{burnin} and \code{thin}.}
}
\value{
Returns an object of class \code{mcmc.list} defined in the \pkg{coda} package.
}
\description{
The functions convert MCMC traces (simulated using \code{\link{run.mig.mcmc}}) into 
objects that can be used with the \pkg{coda} package.
}
