% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ovbias_lm.R
\name{ovbias_lm}
\alias{ovbias_lm}
\title{Compute bias adjusted treatment effect taking three lm objects as input.}
\usage{
ovbias_lm(lm_shrt, lm_int, lm_aux, deltalow, deltahigh, Rhigh, e)
}
\arguments{
\item{lm_shrt}{lm object corresponding to the short regression}

\item{lm_int}{lm object corresponding to the intermediate regression}

\item{lm_aux}{lm object corresponding to the auxiliary regression}

\item{deltalow}{The lower limit of delta}

\item{deltahigh}{The upper limit of delta}

\item{Rhigh}{The upper limit of Rmax}

\item{e}{The step size}
}
\value{
List with three elements:

\item{Data}{Data frame containing the bias and bias-adjusted treatment effect for each point on the grid}
\item{bias_Distribution}{Quantiles (2.5,5.0,50,95,97.5) of the empirical distribution of bias}
\item{bstar_Distribution}{Quantiles (2.5,5.0,50,95,97.5) of the empirical distribution of the bias-adjusted treatment effect}
}
\description{
Compute bias adjusted treatment effect taking three lm objects as input.
}
\examples{
## Load data set
data("NLSY_IQ")
 
## Set age and race as factor variables
NLSY_IQ$age <- factor(NLSY_IQ$age)
NLSY_IQ$race <- factor(NLSY_IQ$race)

## Short regression
reg_s <- lm(iq_std ~ BF_months + factor(age) + sex, data = NLSY_IQ)

## Intermediate regression
reg_i <- lm(iq_std ~ BF_months + 
factor(age) + sex + income + motherAge + 
motherEDU + mom_married + factor(race),
data = NLSY_IQ)

## Auxiliary regression
reg_a <- lm(BF_months ~ factor(age) + 
sex + income + motherAge + motherEDU + 
mom_married + factor(race), data = NLSY_IQ)

## Set limits for the bounded box
Rlow <- summary(reg_i)$r.squared
Rhigh <- 0.61
deltalow <- 0.01
deltahigh <- 0.99
e <- 0.01

\dontrun{
## Compute bias and bias-adjusted treatment effect
ovb_lm <- ovbias_lm(lm_shrt = reg_s,lm_int = reg_i, 
lm_aux = reg_a, deltalow=deltalow, deltahigh=deltahigh, 
Rhigh=Rhigh, e=e)

## Default quantiles of bias
ovb_lm$bias_Distribution

# Default quantiles of bias-adjusted treatment effect
ovb_lm$bstar_Distribution
}

}
