#' Returns coefficients of the cubic equation
#'
#' @param parameters A vector of parameters (real numbers) that is generated by estimating the short, intermediate and auxiliary regressions.
#' @param mydelta The value of delta (real number) 
#' @param Rmax The value of Rmax (real number)
#'
#' @return A data frame with the coefficients of the cubic equation.
#' @export
#'
#' 
partocoef <- function(parameters,mydelta,Rmax){
  with(parameters,{
    a <- (mydelta -1)*(taux)*((sigmax^2) - taux)
    b <- taux*(beta0 - betatilde)*(sigmax^2)*(mydelta-2)
    c <- (mydelta)*(Rmax - Rtilde)*(sigmay^2)*(sigmax^2 - taux) -
      (Rtilde - R0)*(sigmay^2)*taux - ((beta0- betatilde)^2)*taux*(sigmax^2)
    d <-  (mydelta)*(Rmax - Rtilde)*(sigmay^2)*(beta0- betatilde)*(sigmax^2)
    return(data.frame(a=a,b=b,c=c,d=d))
  })
}
