#' Evaluates discriminant of the cubic equation
#'
#' @param parameters A vector of parameters (real numbers) that is generated by estimating the short, intermediate and auxiliary regressions.
#' @param mydelta The value of delta (real number).
#' @param Rmax The value of Rmax (real number)
#'
#' @return Returns a value of 0 or 1; 0 (if discriminant is positive) and 1 (if discriminant is nonpositive)
#' @export
#'
#' 
mydisc <- function(parameters,mydelta,Rmax){
  D <- with(partocoef(parameters,mydelta,Rmax),{
    # Define P and Q
    P <- (3*a*c - (b^2))/(3*(a^2))
    Q <- (27*(a^2)*d + 2*(b^3) - 9*a*b*c)/(27*(a^3))
    # Evaluate discriminant
    4*(P^3)+27*(Q^2)})
  # If D>0: dpos=1 => unique real root 
  # If D<=0: dpos=0 => three real roots 
  dpos <- ifelse(D>0,1,0)
  return(dpos)
}
