% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights.R
\name{weights_mml}
\alias{weights_mml}
\alias{weights_mml,OneStageBasket-method}
\alias{weights_mml,TwoStageBasket-method}
\title{Weights Based on the Marginal Maximum Likelihood}
\usage{
weights_mml(design, ...)

\S4method{weights_mml}{OneStageBasket}(
  design,
  n,
  prune = FALSE,
  lambda,
  globalweight_fun = NULL,
  globalweight_params = list(),
  ...
)

\S4method{weights_mml}{TwoStageBasket}(design, n, n1, ...)
}
\arguments{
\item{design}{An object of class \code{Basket} created by
\code{setupOneStageBasket} or \code{setupTwoStageBasket}.}

\item{...}{Further arguments.}

\item{n}{The sample size per basket.}

\item{prune}{Whether baskets with a number of responses below the
critical pooled value should be pruned before the final analysis.
If this is \code{TRUE} then \code{lambda} is also required and
if \code{globalweight_fun} is not \code{NULL} then
\code{globalweight_fun} and \code{globalweight_params} are also used.}

\item{lambda}{The posterior probability threshold. See details for more
information.}

\item{globalweight_fun}{Which function should be used to calculate the
global weights.}

\item{globalweight_params}{A list of tuning parameters specific to
\code{globalweight_fun}.}

\item{n1}{The sample size per basket for the interim analysis in case of a
two-stage design.}
}
\value{
A matrix including the weights of all possible pairwise outcomes.
}
\description{
Weights Based on the Marginal Maximum Likelihood
}
\details{
\code{weights_mml} calculates the weights based on the marginal
maximum likelihood approach by Gravestock & Held (2017). In this approach,
the weight is found as the maximum of the marginal likelihood of the
weight-parameter given the dataset that information should be borrowed
from. However, since this can lead to non-symmetric weights (meaning that
the amount of information that data set 1 borrows from data set 2 is
generally not identical to the information data set 2 borrows from data set
1), a symmetrised version is used here: For the sharing-weight of
Basket 1 and Basket 2 the MML is calculted two times - once conditional
on the data of Basket 1 and once conditional on the data of Basket 2.
The mean of these two weights is then used, resulting in symmetrical
sharing.
}
\section{Methods (by class)}{
\itemize{
\item \code{weights_mml(OneStageBasket)}: Maximum marginal likelihood weights for a
single-stage basket design

\item \code{weights_mml(TwoStageBasket)}: Maximum marginal likelihood weights for a
two-stage basket design

}}
\examples{
design <- setupOneStageBasket(k = 3, p0 = 0.2)
toer(design, n = 15, lambda = 0.99, weight_fun = weights_mml)
}
\references{
Gravestock, I., & Held, L. (2017). Adaptive power priors with
empirical Bayes for clinical trials. Pharmaceutical statistics, 16(5),
349-360.
}
