% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_dna_to_rna.R
\name{write.dna_to_rna}
\alias{write.dna_to_rna}
\title{Convert DNA file to RNA file}
\usage{
write.dna_to_rna(input_file, output_dir = "")
}
\arguments{
\item{input_file}{The name of the input multi FASTA file.}

\item{output_dir}{The directory where the output file will be saved. If not given,
the output file will be saved in the same directory as the input file.}
}
\value{
A character string specifying the path to the output FASTA file.
}
\description{
This function reads a multi FASTA file containing DNA sequences, converts each DNA sequence to RNA sequence,
and writes the RNA sequences to a new multi FASTA file. The output file name is generated from the input file
name with the suffix '_rna.fasta'.
}
\examples{
#sample_file_path <- system.file("extdata", "sample_fa.fasta", package = "baseq")
#tempdir <- tempdir()
#temp_file_path <- file.path(tempdir, basename(sample_file_path))
#file.copy(sample_file_path, temp_file_path, overwrite = TRUE)
#write.dna_to_rna(temp_file_path, output_dir = tempdir)

# Write to working directory
# write.dna_to_rna(file_path)

# Write to custom directory
# write.dna_to_rna(file_path, output_dir = "/path/to/directory/")

}
