% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdplyr.R
\name{bdplyr}
\alias{bdplyr}
\title{Compatibility with \{dplyr\} verbs without using SQL language}
\usage{
bdplyr(
  table,
  billing_project_id = basedosdados::get_billing_id(),
  query_project_id = "basedosdados"
)
}
\arguments{
\item{table}{String in the format \code{(dataset_name)}.\code{(table_name)}. You can optionally input a project before the dataset name.}

\item{billing_project_id}{a string containing your billing project id.
If you've run \code{\link[=set_billing_id]{set_billing_id()}} then feel free to leave this empty.}

\item{query_project_id}{The project name at GoogleBigQuery. By default
\code{basedosdados}. You do not need to inform this if project is uset
on \code{table} parameter.}
}
\value{
A \verb{lazy tibble}, which can be handled (almost) as if were a local
database. After satisfactorily handled, the result must be loaded into
memory using \code{\link[=bd_collect]{bd_collect()}} or written to disk using \code{\link[=bd_write]{bd_write()}} or its
derivatives.
}
\description{
Allow you to explore and perform operation with Base dos Dados' datasets
without using SQL language. The \code{\link[=bdplyr]{bdplyr()}} function creates \code{lazy} variables
that will be connected directly to the desired table from Base dos Dados at
Google BigQuery and can be handled with the \link[dplyr:dplyr-package]{dplyr::dplyr-package}'s verbs
as traditionally done as local bases. See also: \link[bigrquery:src_bigquery]{bigrquery::src_bigquery}.

Therefore, it is possible (without using \code{SQL}) to perform, for example,
column selection with \code{\link[dplyr:select]{dplyr::select()}}, filter rows with \code{\link[dplyr:filter]{dplyr::filter()}},
operations with \code{\link[dplyr:mutate]{dplyr::mutate()}}, joins with \code{\link[dplyr:mutate-joins]{dplyr::left_join()}} and
other vebs from \code{\{dplyr\}} package.

The data will be automatically be downloaded from Google BigQuery in the
background as it if necessary, but wille not be loaded into your virtual
memory nor recorded on disk unless expressly requested.

For this, the functions such as \code{\link[=bd_collect]{bd_collect()}} or \code{\link[=bd_write]{bd_write()}} should be
used. To load the data handled locally in your virtual memory, use
\code{\link[=bd_collect]{bd_collect()}}. To save the result in disk use the broader function
\code{\link[=bd_write]{bd_write()}} or its derivatives \code{\link[=bd_write_csv]{bd_write_csv()}} or \code{\link[=bd_write_rds]{bd_write_rds()}} to
save, respectively in \code{.csv} or \code{.rds} format.
}
\examples{

\dontrun{

# set project billing id
basedosdados::set_billing_id("avalidprojectbillingid")

# connects to the remote table I want
base_sim <- bdplyr("br_ms_sim.municipio_causa_idade")

# connects to another remote table
municipios <- bdplyr("br_bd_diretorios_brasil.municipio")

# explore data
base_sim \%>\%
  dplyr::glimpse()

# use normal `\{dplyr\}` operations
municipios \%>\%
  head()

# filter
base_sim_acre <- base_sim \%>\%
 dplyr::mutate(ano = as.numeric(ano)) \%>\%
  dplyr::filter(sigla_uf == "AC", ano >= 2018)

municipios_acre <- municipios \%>\%
  dplyr::filter(sigla_uf == "AC") \%>\%
  dplyr::select(id_municipio, municipio, regiao)


# join
base_junta <- base_sim_acre \%>\%
  dplyr::left_join(municipios_acre,
                   by = "id_municipio")

# tests whether the result is satisfactory
base_junta

# collect the result
base_final <- base_junta \%>\%
  basedosdados::bd_collect()

# alternatively, write in disk the result

base_final \%>\%
  basedosdados::bd_write_rds(path = "data-raw/data.rds")

}
}
\seealso{
\code{\link[=bd_collect]{bd_collect()}}, \code{\link[=bd_write]{bd_write()}}, \code{\link[=bd_write_rds]{bd_write_rds()}}, \code{\link[=bd_write_rds]{bd_write_rds()}},
\link[bigrquery:src_bigquery]{bigrquery::src_bigquery}
}
