% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viviBart.R
\name{viviBart}
\alias{viviBart}
\title{viviBart}
\usage{
viviBart(trees, out = "vivi")
}
\arguments{
\item{trees}{A data frame created by `extractTreeData` function.}

\item{out}{Choose to either output just the variable importance ('vimp'),
the variable interaction ('vint'), or both ('vivi') (default).}
}
\value{
A list of dataframes of VIVI summaries.
}
\description{
Returns a list containing a dataframe of variable importance summaries
and a dataframe of variable interaction summaries.
}
\examples{
if(requireNamespace("dbarts", quietly = TRUE)){
 # Load the dbarts package to access the bart function
 library(dbarts)
 # Get Data
 df <- na.omit(airquality)
 # Create Simple dbarts Model For Regression:
 set.seed(1701)
 dbartModel <- bart(df[2:6], df[, 1], ntree = 5, keeptrees = TRUE, nskip = 10, ndpost = 10)

 # Tree Data
 trees_data <- extractTreeData(model = dbartModel, data = df)
 viviBart(trees = trees_data, out = 'vivi')
 }


}
