% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proximitymatrix.R
\name{proximityMatrix}
\alias{proximityMatrix}
\title{proximityMatrix}
\usage{
proximityMatrix(trees, nRows, normalize = TRUE, reorder = TRUE, iter = NULL)
}
\arguments{
\item{trees}{A list of tree attributes created by `extractTreeData` function.}

\item{nRows}{Number of rows to consider.}

\item{normalize}{Default is TRUE. Divide the total number of pairs of observations by
the number of trees.}

\item{reorder}{Default is TRUE. Whether to sort the matrix so high values are pushed to top left.}

\item{iter}{Which iteration to use, if NULL the proximity matrix is calculated over all
iterations.}
}
\value{
A matrix containing proximity values.
}
\description{
Creates a matrix of proximity values.
}
\examples{
if(requireNamespace("dbarts", quietly = TRUE)){
 # Load the dbarts package to access the bart function
 library(dbarts)
 # Get Data
 df <- na.omit(airquality)
 # Create Simple dbarts Model For Regression:
 set.seed(1701)
 dbartModel <- bart(df[2:6], df[, 1], ntree = 5, keeptrees = TRUE, nskip = 10, ndpost = 10)

 # Tree Data
 trees_data <- extractTreeData(model = dbartModel, data = df)
 # Create Proximity Matrix
 mProx <- proximityMatrix(trees = trees_data, reorder = TRUE, normalize = TRUE, iter = 1)
}
}
