% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oop.R
\name{use_method}
\alias{use_method}
\title{Use a method in an object environment}
\usage{
use_method(env, fn, container_name = "..method_env..")
}
\arguments{
\item{env}{Environment. Object.}

\item{fn}{Function. Method.}

\item{container_name}{Character. Name of the container.}
}
\value{
A method.
}
\description{
This function makes a copy of the function, then set the evaluation
environment to the container of the object environment.
}
\examples{

TEST <- new_class(class_name = "TEST")

register_method(TEST, ..str.. = function() "test")

test <- TEST$instantiate(dist = "uniform", prm = list(a = 1, b = 2))
test$..str..()

# Use method `..str..` from BASE class
use_method(test, BASE$..str..)()

}
