% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oop_s3.R
\name{\%le\%.bandicoot_oop}
\alias{\%le\%.bandicoot_oop}
\title{S3 method of performing the less or equals operator of a
\code{bandicoot_oop} object}
\usage{
\method{\%le\%}{bandicoot_oop}(x, y)
}
\arguments{
\item{x}{\code{bandicoot_oop} object.}

\item{y}{Object.}
}
\value{
A Boolean value.
}
\description{
This function performs the less or equals operator using the \code{..le..()} method.
If it is not applicable, error will be raised.
}
\examples{
NAME <- new_class(class_name = "NAME")
name <- NAME$instantiate
register_method(NAME,
                ..init.. = function(first_name, last_name) {
                  self$first_name = first_name
                  self$last_name = last_name
                })
register_method(NAME,
                ..le.. = function(y) {
                  if (self$last_name == y$last_name) {
                    return(self$first_name <= y$first_name)
                  }
                  return(self$last_name <= self$last_name)
                })

patrick <- name("Patrick", "Li")
james <- name("James", "Li")
patrick \%le\% james

}
