% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-basic.R
\name{melt_vector}
\alias{melt_vector}
\title{melt a vector into single value}
\usage{
melt_vector(x, method = "first", invalid = NA)
}
\arguments{
\item{x}{vector}

\item{method}{how to melt, should be one of
\code{first|last}, or one of \code{sum|mean|median} for numeric vector,
or some characters (e.g. \verb{,|.| |;}) for character vector}

\item{invalid}{invalid value to ignore, \code{NA} as default}
}
\value{
melted single value
}
\description{
melt a vector into single value
}
\examples{

melt_vector(c(NA, 2, 3), method = "first")

melt_vector(c(NA, 2, 3), method = "sum")

melt_vector(c(NA, 2, 3), method = ",")

melt_vector(c(NA, 2, Inf), invalid = c(NA, Inf))

}
