% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/badgen.R
\name{badgen}
\alias{badgen}
\title{Generate badges}
\usage{
badgen(
  label,
  status = "v1.2.3",
  color = "green",
  labelColor = "555",
  style = "classic",
  scale = 1,
  svg_icon = NULL
)
}
\arguments{
\item{label}{text for left part of the badge}

\item{status}{text for right part of the badge}

\item{color}{background for status part}

\item{labelColor}{background for label part}

\item{style}{one of 'classic' or 'flat'}

\item{scale}{resize badge, default size is 1}

\item{svg_icon}{iteral svg string with icon, see examples}
}
\value{
svg string with the badge
}
\description{
Generate a badge in the form of an svg string. Svg files can embedded directly
in websites or converted to png as shown in examples.
}
\examples{
home <- setwd(tempdir())
svg <- badgen("yolo", "success!", style = 'flat')
writeLines(svg, 'test.svg')
browseURL('test.svg')

# Convert svg to bitmap
rsvg::rsvg_png('test.svg', 'test.png')

# Add an svg icon to the badge
rlogo <- readLines('https://www.r-project.org/logo/Rlogo.svg')
svg2 <- badgen('mypkg', 'awesome', scale = 4, svg_icon = rlogo)
writeLines(svg2, 'test2.svg')
browseURL('test2.svg')

# Cleanup
Sys.sleep(1)
unlink(c('test.svg', 'test.png', 'test2.svg'))
setwd(home)
}
