% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/av_lm.R
\name{av.lm}
\alias{av.lm}
\title{Convert a Linear Model (lm) Object to Anytime-Valid lm (avlm)}
\usage{
\method{av}{lm}(model, g = 1, vcov_estimator = NULL, ...)
}
\arguments{
\item{model}{An \code{lm} object from a linear model fit.}

\item{g}{An integer precision parameter for anytime-valid inference. Default is 1.}

\item{vcov_estimator}{Optional character string specifying the type of robust standard errors
to use. Must be one of \code{"HC0"}, \code{"HC1"}, \code{"HC2"}, or \code{"HC3"}.
If \code{NULL} (default), no robust variance estimation is applied.}

\item{...}{Additional arguments passed to or from other methods.}
}
\value{
An enhanced \code{lm} object of class \code{avlm} with anytime-valid inference capabilities.
}
\description{
Converts an \code{lm} object into an anytime-valid version by storing a precision parameter
\code{g} as an attribute and updating the object's class. The resulting object supports anytime-valid inference.
}
\examples{
# Fit a linear model on the built-in mtcars dataset
fit <- lm(mpg ~ wt + hp, data = mtcars)

# Convert the standard lm object to an anytime-valid avlm object
av_fit <- av(fit, g = 1)

# Print the summary of the anytime-valid model
summary(av_fit)

}
