% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{am_sync_state}
\alias{am_sync_state}
\title{Create a new sync state}
\usage{
am_sync_state()
}
\value{
An external pointer to the sync state with class \code{"am_syncstate"}.
}
\description{
Creates a new synchronization state for managing communication with a peer.
The sync state tracks what changes have been sent and received, enabling
efficient incremental synchronization.
}
\details{
\strong{IMPORTANT}: Sync state is document-independent. The same sync state
is used across multiple sync message exchanges with a specific peer.
The document is passed separately to \code{am_sync_encode()} and \code{am_sync_decode()}.
}
\examples{
# Create two documents
doc1 <- am_create()
doc2 <- am_create()

# Create sync states for each peer
sync1 <- am_sync_state()
sync1
sync2 <- am_sync_state()

# Use with am_sync_encode() and am_sync_decode()

am_close(doc1)
am_close(doc2)

}
