% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survfit2df.R
\name{survfit2df}
\alias{survfit2df}
\title{Extract survival data from an object of class "survfit"}
\usage{
survfit2df(fit, labels = NULL)
}
\arguments{
\item{fit}{An object of class "survfit"}

\item{labels}{Character}
}
\value{
A data.frame
}
\description{
Extract survival data from an object of class "survfit"
}
\examples{
library(survival)
data(cancer,package="survival")
fit=survfit(coxph(Surv(time,status)~sex+age+strata(rx),data=colon))
survfit2df(fit)
\dontrun{
fit=coxph(Surv(time,status)~sex+age+strata(rx),data=colon)
fit=survfit(as.formula(deparse(fit$terms)),data=fit2model(fit))
survfit2df(fit)
fit=survfit(Surv(time,status)~rx+sex+age,data=colon)
survfit2df(fit)
fit=survfit(Surv(time,status)~1,data=colon)
survfit2df(fit)
}
}
