% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{model_list_pca}
\alias{model_list_pca}
\title{A list of models for the best subset selection with PCA.}
\usage{
model_list_pca(y, L1.x, L2.x, L2.unit, L2.reg = NULL)
}
\arguments{
\item{y}{Outcome variable. A character vector containing the column names of
the outcome variable.}

\item{L1.x}{Individual-level covariates. A character vector containing the
column names of the individual-level variables in \code{survey} and
\code{census} used to predict outcome \code{y}. Note that geographic unit
is specified in argument \code{L2.unit}.}

\item{L2.x}{Context-level covariates. A character vector containing the
column names of the context-level variables in \code{survey} and
\code{census} used to predict outcome \code{y}.}

\item{L2.unit}{Geographic unit. A character scalar containing the column name
of the geographic unit in \code{survey} and \code{census} at which outcomes
should be aggregated.}

\item{L2.reg}{Geographic region. A character scalar containing the column
name of the geographic region in \code{survey} and \code{census} by which
geographic units are grouped (\code{L2.unit} must be nested within
\code{L2.reg}). Default is \code{NULL}.}
}
\value{
Returns a list with the number of elements k+1 where k is the number
  of context-level variables. Each element is of class formula. The first
  element is a model with context-level variables and the following models
  iteratively add the principal components as context-level variables.
}
\description{
\code{model_list_pca()} generates an exhaustive list of lme4 model formulas
from the individual level and context level principal components as well as
geographic unit variables to be iterated over in best subset selection with
principal components.
}
