% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{error_checks}
\alias{error_checks}
\title{Catches user input errors}
\usage{
error_checks(
  y,
  L1.x,
  L2.x,
  L2.unit,
  L2.reg,
  L2.x.scale,
  pcs,
  folds,
  bin.proportion,
  bin.size,
  survey,
  census,
  ebma.size,
  k.folds,
  cv.sampling,
  loss.unit,
  loss.fun,
  best.subset,
  lasso,
  pca,
  gb,
  svm,
  mrp,
  best.subset.L2.x,
  lasso.L2.x,
  gb.L2.x,
  svm.L2.x,
  mrp.L2.x,
  gb.L2.unit,
  gb.L2.reg,
  lasso.lambda,
  lasso.n.iter,
  uncertainty,
  boot.iter
)
}
\arguments{
\item{y}{Outcome variable. A character vector containing the column names of
the outcome variable. A character scalar containing the column name of
the outcome variable in \code{survey}.}

\item{L1.x}{Individual-level covariates. A character vector containing the
column names of the individual-level variables in \code{survey} and
\code{census} used to predict outcome \code{y}. Note that geographic unit
is specified in argument \code{L2.unit}.}

\item{L2.x}{Context-level covariates. A character vector containing the
column names of the context-level variables in \code{survey} and
\code{census} used to predict outcome \code{y}. To exclude context-level
variables, set \code{L2.x = NULL}.}

\item{L2.unit}{Geographic unit. A character scalar containing the column
name of the geographic unit in \code{survey} and \code{census} at which
outcomes should be aggregated.}

\item{L2.reg}{Geographic region. A character scalar containing the column
name of the geographic region in \code{survey} and \code{census} by which
geographic units are grouped (\code{L2.unit} must be nested within
\code{L2.reg}). Default is \code{NULL}.}

\item{L2.x.scale}{Scale context-level covariates. A logical argument
indicating whether the context-level covariates should be normalized.
Default is \code{TRUE}. Note that if set to \code{FALSE}, then the
context-level covariates should be normalized prior to calling
\code{auto_MrP()}.}

\item{pcs}{Principal components. A character vector containing the column
names of the principal components of the context-level variables in
\code{survey} and \code{census}. Default is \code{NULL}.}

\item{folds}{EBMA and cross-validation folds. A character scalar containing
the column name of the variable in \code{survey} that specifies the fold
to which an observation is allocated. The variable should contain integers
running from \eqn{1} to \eqn{k + 1}, where \eqn{k} is the number of
cross-validation folds. Value \eqn{k + 1} refers to the EBMA fold. Default
is \code{NULL}. \emph{Note:} if \code{folds} is \code{NULL}, then
\code{ebma.size}, \code{k.folds}, and \code{cv.sampling} must be specified.}

\item{bin.proportion}{Proportion of ideal types. A character scalar
containing the column name of the variable in \code{census} that indicates
the proportion of individuals by ideal type and geographic unit. Default is
\code{NULL}. \emph{Note:} if \code{bin.proportion} is \code{NULL}, then
\code{bin.size} must be specified.}

\item{bin.size}{Bin size of ideal types. A character scalar containing the
column name of the variable in \code{census} that indicates the bin size of
ideal types by geographic unit. Default is \code{NULL}. \emph{Note:}
ignored if \code{bin.proportion} is provided, but must be specified
otherwise.}

\item{survey}{Survey data. A \code{data.frame} whose column names include
\code{y}, \code{L1.x}, \code{L2.x}, \code{L2.unit}, and, if specified,
\code{L2.reg}, \code{pcs}, and \code{folds}.}

\item{census}{Census data. A \code{data.frame} whose column names include
\code{L1.x}, \code{L2.x}, \code{L2.unit}, if specified, \code{L2.reg} and
\code{pcs}, and either \code{bin.proportion} or \code{bin.size}.}

\item{ebma.size}{EBMA fold size. A number in the open unit interval
indicating the proportion of respondents to be allocated to the EBMA fold.
Default is \eqn{1/3}. \emph{Note:} ignored if \code{folds} is provided, but
must be specified otherwise.}

\item{k.folds}{Number of cross-validation folds. An integer-valued scalar
indicating the number of folds to be used in cross-validation. Default is
\eqn{5}. \emph{Note:} ignored if \code{folds} is provided, but must be
specified otherwise.}

\item{cv.sampling}{Cross-validation sampling method. A character-valued
scalar indicating whether cross-validation folds should be created by
sampling individual respondents (\code{individuals}) or geographic units
(\code{L2 units}). Default is \code{L2 units}. \emph{Note:} ignored if
\code{folds} is provided, but must be specified otherwise.}

\item{loss.unit}{Loss function unit. A character-valued scalar indicating
whether performance loss should be evaluated at the level of individual
respondents (\code{individuals}), geographic units (\code{L2 units}) or at
both levels. Default is \code{c("individuals", "L2 units")}. With multiple
loss units, parameters are ranked for each loss unit and the loss unit with
the lowest rank sum is chosen. Ties are broken according to the order in
the search grid.}

\item{loss.fun}{Loss function. A character-valued scalar indicating whether
prediction loss should be measured by the mean squared error (\code{MSE}),
the mean absolute error (\code{MAE}), binary cross-entropy
(\code{cross-entropy}), mean squared false error (\code{msfe}), the f1
score (\code{f1}), or a combination thereof. Default is \code{c("MSE",
"cross-entropy","msfe", "f1")}. With multiple loss functions, parameters
are ranked for each loss function and the parameter combination with the
lowest rank sum is chosen. Ties are broken according to the order in the
search grid.}

\item{best.subset}{Best subset classifier. A logical argument indicating
whether the best subset classifier should be used for predicting outcome
\code{y}. Default is \code{TRUE}.}

\item{lasso}{Lasso classifier. A logical argument indicating whether the
lasso classifier should be used for predicting outcome \code{y}. Default is
\code{TRUE}.}

\item{pca}{PCA classifier. A logical argument indicating whether the PCA
classifier should be used for predicting outcome \code{y}. Default is
\code{TRUE}.}

\item{gb}{GB classifier. A logical argument indicating whether the GB
classifier should be used for predicting outcome \code{y}. Default is
\code{TRUE}.}

\item{svm}{SVM classifier. A logical argument indicating whether the SVM
classifier should be used for predicting outcome \code{y}. Default is
\code{TRUE}.}

\item{mrp}{MRP classifier. A logical argument indicating whether the standard
MRP classifier should be used for predicting outcome \code{y}. Default is
\code{FALSE}.}

\item{best.subset.L2.x}{Best subset context-level covariates. A character
vector containing the column names of the context-level variables in
\code{survey} and \code{census} to be used by the best subset classifier.
If \code{NULL} and \code{best.subset} is set to \code{TRUE}, then best
subset uses the variables specified in \code{L2.x}. Default is \code{NULL}.}

\item{lasso.L2.x}{Lasso context-level covariates. A character vector
containing the column names of the context-level variables in
\code{survey} and \code{census} to be used by the lasso classifier. If
\code{NULL} and \code{lasso} is set to \code{TRUE}, then lasso uses the
variables specified in \code{L2.x}. Default is \code{NULL}.}

\item{gb.L2.x}{GB context-level covariates. A character vector containing the
column names of the context-level variables in \code{survey} and
\code{census} to be used by the GB classifier. If \code{NULL} and \code{gb}
is set to \code{TRUE}, then GB uses the variables specified in \code{L2.x}.
Default is \code{NULL}.}

\item{svm.L2.x}{SVM context-level covariates. A character vector containing
the column names of the context-level variables in \code{survey} and
\code{census} to be used by the SVM classifier. If \code{NULL} and
\code{svm} is set to \code{TRUE}, then SVM uses the variables specified in
\code{L2.x}. Default is \code{NULL}.}

\item{mrp.L2.x}{MRP context-level covariates. A character vector containing
the column names of the context-level variables in \code{survey} and
\code{census} to be used by the MRP classifier. The character vector
\emph{empty} if no context-level variables should be used by the MRP
classifier. If \code{NULL} and \code{mrp} is set to \code{TRUE}, then MRP
uses the variables specified in \code{L2.x}. Default is \code{NULL}. Note:
For the empty MrP model, set \code{L2.x = NULL} and \code{mrp.L2.x = ""}.}

\item{gb.L2.unit}{GB L2.unit. A logical argument indicating whether
\code{L2.unit} should be included in the GB classifier. Default is
\code{FALSE}.}

\item{gb.L2.reg}{GB L2.reg. A logical argument indicating whether
\code{L2.reg} should be included in the GB classifier. Default is
\code{FALSE}.}

\item{lasso.lambda}{Lasso penalty parameter. A numeric \code{vector} of
non-negative values. The penalty parameter controls the shrinkage of the
context-level variables in the lasso model. Default is a sequence with
minimum 0.1 and maximum 250 that is equally spaced on the log-scale. The
number of values is controlled by the \code{lasso.n.iter} parameter.}

\item{lasso.n.iter}{Lasso number of lambda values. An integer-valued scalar
specifying the number of lambda values to search over. Default is
\eqn{100}. \emph{Note:} Is ignored if a vector of \code{lasso.lambda}
values is provided.}

\item{uncertainty}{Uncertainty estimates. A logical argument indicating
whether uncertainty estimates should be computed. Default is \code{FALSE}.}

\item{boot.iter}{Number of bootstrap iterations. An integer argument
indicating the number of bootstrap iterations to be computed. Will be
ignored unless \code{uncertainty = TRUE}. Default is \code{200} if
\code{uncertainty = TRUE} and \code{NULL} if \code{uncertainty = FALSE}.}
}
\value{
No return value, called for detection of errors in autoMrP() call.
}
\description{
\code{error_checks()} checks for incorrect data entry in \code{autoMrP()}
call.
}
