% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_feature_importance.R
\name{calculate_feature_importance}
\alias{calculate_feature_importance}
\title{Calculate Feature Importance for Anomalies}
\usage{
calculate_feature_importance(flagged_data, metadata, top_k = 1, max_cols = 10)
}
\arguments{
\item{flagged_data}{A data frame with anomaly scores and is_anomaly flags,
typically the output of \code{flag_top_anomalies()}.}

\item{metadata}{Metadata from \code{prep_for_anomaly()}, containing
information about numeric and categorical columns.}

\item{top_k}{Integer indicating how many top contributing features to consider.
Default is 1 (returns only the most important feature).}

\item{max_cols}{Integer indicating maximum number of columns to consider for
feature importance. If NULL, uses all columns. Default is 10 for performance.}
}
\value{
The input data frame with additional columns:
  \item{reason_feature}{Name of the feature contributing most to the anomaly}
  \item{reason_value}{The value of that feature for this record}
  \item{reason_code}{A brief description combining feature name and value}
  \item{reason_deviation}{The standardized deviation from the median (for numeric) or frequency (for categorical)}
}
\description{
Calculates which feature contributes most to each record's anomaly score.
This provides a "reason code" explaining why each record was flagged as anomalous.
}
\examples{
\donttest{
data <- data.frame(
  patient_id = 1:50,
  age = rnorm(50, 50, 15),
  cost = rnorm(50, 10000, 5000)
)
scored_data <- score_anomaly(data, id_cols = "patient_id")
flagged_data <- flag_top_anomalies(scored_data)
metadata <- attr(scored_data, "metadata")
flagged_data <- calculate_feature_importance(flagged_data, metadata)
}
}
