% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc_compare.R
\name{se_auc}
\alias{se_auc}
\title{Compute standard error of AUC score, using its equivalence to the Wilcoxon statistic.}
\usage{
se_auc(auc, n_p, n_n)
}
\arguments{
\item{auc}{value of A' statistic (or AUC, or Area Under the Receiver operating
characteristic curve) (numeric).}

\item{n_p}{number of positive cases (integer).}

\item{n_n}{number of negative cases (integer).}
}
\description{
Compute standard error of AUC score, using its equivalence to the Wilcoxon statistic.
}
\examples{
se_auc(0.75, 20, 200)
## standard error decreases when data become more balanced over
## positive/negative outcome class, holding sample size fixed
se_auc(0.75, 110, 110)
## standard error increases when sample size shrinks
se_auc(0.75, 20, 20)
}
\references{
Hanley and McNeil, The meaning and use of the area under a receiver
operating characteristic (ROC) curve. Radiology (1982) 43 (1) pp. 29-36.

Fogarty, Baker and Hudson, Case Studies in the use of ROC Curve Analysis
for Sensor-Based Estimates in Human Computer Interaction,
Proceedings of Graphics Interface (2005) pp. 129-136.
}
\seealso{
Other fbh method: \code{\link{auc_compare}},
  \code{\link{fbh_test}}
}
