% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinates.R, R/rotation.R
\name{astro_vector_from_sphere}
\alias{astro_vector_from_sphere}
\title{Convert Spherical Coordinates to Cartesian Vector}
\usage{
astro_vector_from_sphere(sphere, time)

astro_vector_from_sphere(sphere, time)
}
\arguments{
\item{sphere}{A list with components:
\describe{
\item{lat}{Latitude angle: -90..+90 degrees}
\item{lon}{Longitude angle: 0..360 degrees}
\item{dist}{Distance in AU}
}}

\item{time}{POSIXct time at which the coordinates are valid}
}
\value{
A list representing a Cartesian vector with elements:
\itemize{
\item \code{x}, \code{y}, \code{z}: Cartesian coordinates in AU
\item \code{t}: Time value
\item \code{status}: Status code (0 = success)
}

A list representing a vector with components:
\describe{
\item{x}{The Cartesian x-coordinate in AU}
\item{y}{The Cartesian y-coordinate in AU}
\item{z}{The Cartesian z-coordinate in AU}
\item{t}{The date and time (POSIXct) at which this vector is valid}
\item{status}{Status code (0 = success)}
}
}
\description{
Given spherical coordinates and a time at which they are valid,
returns a vector of Cartesian coordinates. The returned value
includes the time, as required by the vector structure.

Given spherical coordinates and a time at which they are valid,
returns a vector of Cartesian coordinates. The returned value
includes the time, as required by the vector type.
}
\examples{
sphere <- list(lat = 45, lon = 90, dist = 1.5)
time <- as.POSIXct("2024-01-01 12:00:00", tz = "UTC")
vec <- astro_vector_from_sphere(sphere, time)

# Convert spherical to Cartesian
sphere <- list(lat = 0, lon = 0, dist = 1)
time <- as.POSIXct("2024-01-01", tz = "UTC")
vec <- astro_vector_from_sphere(sphere, time)
}
