% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oppositions_conjunctions.R
\name{astro_search_relative_longitude}
\alias{astro_search_relative_longitude}
\title{Search for relative longitude event between Earth and another planet}
\usage{
astro_search_relative_longitude(body, target_rel_lon, start_time)
}
\arguments{
\item{body}{An integer representing a planet other than Earth (see \verb{[astro_body]}).
Cannot be the Earth, Moon, or Sun.}

\item{target_rel_lon}{Numeric. The desired relative longitude in degrees.
Must be in the range [0, 360).}

\item{start_time}{A \code{POSIXct} datetime object specifying when to begin
the search.}
}
\value{
A \code{POSIXct} datetime object indicating when the target relative
longitude is reached.
}
\description{
Searches for the next time when the relative longitude (angle measured in
the ecliptic plane from one planet to another as seen from the Sun) reaches
a specified target angle.
}
\details{
Relative longitude defines several important astronomical events:
\describe{
\item{0°}{Conjunction (inferior for Mercury/Venus, opposition for outer planets)}
\item{180°}{Superior conjunction (planet on opposite side of Sun from Earth)}
}

For planets orbiting closer to the Sun than Earth (Mercury, Venus),
a relative longitude of 0° indicates inferior conjunction.
For planets orbiting farther from the Sun, 0° indicates opposition (closest approach).
}
\examples{
# Find next opposition of Mars after 2025-01-01
start <- as.POSIXct("2025-01-01", tz = "UTC")
astro_search_relative_longitude(astro_body["MARS"], 0, start)
}
