% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotation.R
\name{astro_rotation_EQD_EQJ}
\alias{astro_rotation_EQD_EQJ}
\title{Rotation Matrix from EQD to EQJ}
\usage{
astro_rotation_EQD_EQJ(time)
}
\arguments{
\item{time}{A POSIXct object representing the date and time at which the Earth's
equator defines the source orientation.}
}
\value{
A rotation matrix that converts EQD to EQJ.
}
\description{
Calculates a rotation matrix from equatorial of-date (EQD) to J2000 mean
equator (EQJ).
}
\details{
This is one of the family of functions that returns a rotation matrix
for converting from one orientation to another.

\strong{Source}: EQD = equatorial system, using equator of the specified date/time.

\strong{Target}: EQJ = equatorial system, using mean equator at J2000 epoch.
}
\examples{
astro_rotation_EQD_EQJ(Sys.time())

}
