% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position.R
\name{astro_ecliptic_longitude}
\alias{astro_ecliptic_longitude}
\title{Heliocentric ecliptic longitude of a body}
\usage{
astro_ecliptic_longitude(body, time)
}
\arguments{
\item{body}{Identifier of celestial body (e.g., \code{astro_body[["MARS"]]}).
Must not be the Sun.}

\item{time}{A POSIXct time value.}
}
\value{
A numeric value with the ecliptic longitude in degrees [0, 360).
}
\description{
Calculates the angle around the ecliptic plane of a celestial body as seen from
the center of the Sun. The angle is measured prograde (in the direction of Earth's
orbit) in degrees from the true equinox of date, with values in the range [0, 360).
}
\examples{
time <- as.POSIXct("2025-02-19 22:10:12", tz = "UTC")
astro_ecliptic_longitude(astro_body[["MARS"]], time)
}
