% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotation.R
\name{astro_combine_rotation}
\alias{astro_combine_rotation}
\title{Combine two rotation matrices}
\usage{
astro_combine_rotation(a, b)
}
\arguments{
\item{a}{The first rotation to apply}

\item{b}{The second rotation to apply}
}
\value{
The combined rotation matrix
}
\description{
Given two rotation matrices, returns a combined rotation matrix that is
equivalent to rotating based on the first matrix, followed by the second.
}
\examples{
# Combine two identity matrices (result is also identity)
rot_a <- astro_identity_matrix()
rot_b <- astro_identity_matrix()
combined <- astro_combine_rotation(rot_a, rot_b)
}
