% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{has_class}
\alias{has_class}
\title{Returns TRUE if data.frame columns have a specified class}
\usage{
has_class(..., class)
}
\arguments{
\item{...}{An arbitrary amount of quoted column names to check for}

\item{class}{Expected class for chosen columns.}
}
\value{
TRUE if all classes are correct, FALSE if not
}
\description{
This is meant to be used with `assertr`'s `verify` function to check
for the existence of a specific column class in a `data.frame` that is
piped to `verify`.
}
\examples{

verify(mtcars, has_class("mpg", "wt", class = "numeric"))

library(magrittr)   # for pipe operator

\dontrun{
mtcars \%>\%
  verify(has_class("mpg", class = "character"))  # fails
}

}
