% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_compare.R
\name{assert_all_between}
\alias{assert_all_between}
\title{Assert input is between a specified minimum and maximum value}
\usage{
assert_all_between(
  x,
  minimum,
  maximum,
  inclusive = TRUE,
  msg = NULL,
  call = rlang::caller_env(),
  arg_name = NULL
)
}
\arguments{
\item{x}{An object to check}

\item{minimum}{The minimum value to compare against (number)}

\item{maximum}{The maximum value to compare against (number)}

\item{inclusive}{should comparisons allow equality with the minimum and maximum values? (flag)}

\item{msg}{A character string containing the error message to display if \code{x} is not between the specified minimum and maximum values (string)}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if \code{x} is between the specified minimum and maximum values, otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert all elements in a numeric vector/matrix are between some minimum and maximum values.
}
\examples{
try({
assert_all_between(3, 1, 4) # Passes
assert_all_between(c(2,3,4), 1, 4) # Passes
assert_all_between(c(2,3,4), 2, 4) # Passes
assert_all_between(c(2,3,1), 2, 4) # Throws default error
assert_all_between(c(2,3,1), 2, 4, msg = "custom error message") # Throws custom error
})

}
\concept{assert_comparison}
