% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_files.R
\name{assert_file_does_not_exist}
\alias{assert_file_does_not_exist}
\title{Assert a file does not exist}
\usage{
assert_file_does_not_exist(
  x,
  msg = NULL,
  call = rlang::caller_env(),
  arg_name = NULL
)
}
\arguments{
\item{x}{Path to a file (string)}

\item{msg}{A character string containing the error message if file \code{x} already exists}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if file \code{x} does not exist, otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert that a file does not exist. Useful for avoiding overwriting.
}
\examples{
real_file <- system.file("DESCRIPTION", package = "assertions")

try({
assert_file_does_not_exist("foo") # Passes
assert_file_does_not_exist(real_file) # Throws error
assert_file_does_not_exist(c("foo", "bar")) # Throws Error (single file only)
})

}
\concept{assert_file}
