% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asciiruler.R
\name{genbank_seqblock}
\alias{genbank_seqblock}
\title{Generate a GenBank sequence block}
\usage{
genbank_seqblock(string, start = 1L, end = 0L, blocksize = 10L,
  width = 60L, sep = " ", line_break = "\\n", ruler = TRUE, ...)
}
\arguments{
\item{string}{the sequence string to display}

\item{start}{the substring start, should be 1 or greater}

\item{end}{substring end, should be >start, negative to trim}

\item{blocksize}{number of characters in each block}

\item{width}{width of the sequence block}

\item{sep}{space character between blocks}

\item{line_break}{the line break character(s)}

\item{ruler}{display an ascii ruler}

\item{...}{additional arguments passed to asciiruler}
}
\value{
delimited GenBank block string ready to cat
}
\description{
'   \preformatted{
'     1    6     11   16    21   26    31   36    41   46    51   56   
'     |    |     |    |     |    |     |    |     |    |     |    |    
'     |||||||||| |||||||||| |||||||||| |||||||||| |||||||||| ||||||||||
'   1 GATCACAGGT CTATCACCCT ATTAACCACT CACGGGAGCT CTCCATGCAT TTGGTATTTT
'  61 CGTCTGGGGG GTGTGCACGC GATAGCATTG CGAGACGCTG GAGCCGGAGC ACCCTATGTC
' 121 GCAGTATCTG TCTTTGATTC CTGCCCCATC CTATTATTTA TCGCACCTAC GTTCAATATT
' 181 ACAGGCGAAC ATACTTACTA AAGTGTGTTA ATTAATTAAT GCTTGTAGGA CATAATAATA
' 241 ACAATTGAAT GTCTGCACAG CCGCTTTCCA CACAGACATC ATAACAAAAA ATTTCCACCA
' 301 AACCCCCCCT CCCCCGCTTC TGGCCACAGC ACTTAAACAC ATCTCTGC
' }
}
\examples{
my_sequence<-'GATCACAGGTCTATCACCCTATTAACCACTCACGGGAGCTCTCCATGCATTTGGTATTTTCGTCTGGGGG
GTATGCACGCGATAGCATTGCGAGACGCTGGAGCCGGAGCACCCTATGTCGCAGTATCTGTCTTTGATTC
CTGCCTCATCCTATTATTTATCGCACCTACGTTCAATATTACAGGCGAACATACTTACTAAAGTGTGTTA
ATTAATTAATGCTTGTAGGACATAATAATAACAATTGAATGTCTGCACAGCCACTTTCCACACAGACATC'
my_seqblock<-genbank_seqblock(my_sequence)
cat(my_seqblock)
}
