% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getintersectx.R
\name{getintersectx}
\alias{getintersectx}
\title{Calculates x-coordinate interpolation points across a baseline.}
\usage{
getintersectx(data, xcoord, ycoord, ybase = NA)
}
\arguments{
\item{data}{A dataframe with x- and y-coordinates in wide format.}

\item{xcoord}{A specified selection of the x-coordinate values within
the dataframe.}

\item{ycoord}{A specified selection of the y-coordinate values within
the dataframe.}

\item{ybase}{A specified selection of the baseline of the 'y' measured
variable.
Users are advised to place baseline as the first instance of the
y-coordinate values. Function defaults to use the first y-coordinate value
in the series.}
}
\value{
A dataframe of old and newly-interpolated x-coordinate values
at the specified baseline.
}
\description{
This function takes a series of 'x,y' coordinates and a specified 'y'
baseline value. For any two sequential x-coordinate points, where the
'y' baseline value is crossed in between them, the function calculates
the predicted x-coordinate value and interpolates that point with the
matching 'y' baseline value. The new points are then added to the original
set of 'x,y' coordinates. Note that all the prefixed arse functions
automatically perform this operation within their respective functions.
}
\examples{
xc <- t(c(1,2,3,4,5,6,7,8,9,10))
yc <- t(c(75,53,37,25,95,35,50,75,75,75))
dataset1 <- data.frame(xc, yc)
getintersectx(data = dataset1, xcoord = dataset1[,1:10], ycoord = dataset1[,11:20])
}
