% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nutrient_functions.R
\name{economic_analysis}
\alias{economic_analysis}
\title{Economic Analysis for Arid Agriculture}
\usage{
economic_analysis(
  yield,
  price,
  cost_fixed,
  cost_variable,
  byproduct_yield = 0,
  byproduct_price = 0,
  verbose = TRUE
)
}
\arguments{
\item{yield}{Crop yield (kg/ha)}

\item{price}{Market price (Rs/kg)}

\item{cost_fixed}{Fixed costs (Rs/ha)}

\item{cost_variable}{Variable costs (Rs/ha)}

\item{byproduct_yield}{Byproduct yield (kg/ha), optional}

\item{byproduct_price}{Byproduct price (Rs/kg), optional}

\item{verbose}{Logical. If TRUE (default), prints formatted output to console.}
}
\value{
Data frame with economic analysis
}
\description{
Calculates economic indicators including Cost of Cultivation, Gross Returns,
Net Returns, B:C Ratio, and profitability indices for arid farming systems.
}
\examples{
economic_analysis(yield = 1200, price = 65, cost_fixed = 15000, cost_variable = 12000)

# With byproduct
economic_analysis(yield = 1200, price = 65, cost_fixed = 15000, 
                  cost_variable = 12000, byproduct_yield = 1800, byproduct_price = 5)

}
\author{
Lalit Kumar Rolaniya, ICAR-IIPR, Bikaner
}
